#include "General.h"
#include "BetterPPAGEConsoleCommand.h"
#include "CommandLineParser.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "gmgame.h"
#include "Iterator.h"

StringClass PrependText, SoundFile;
unsigned int RedColour, GreenColour, BlueColour;

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

static int getClientIdByIdentifier(const char* clientIdentifier)
{
	assert(clientIdentifier);
	const cPlayer* player = Find_Player(atoi(clientIdentifier));
	int result;
	if (player)
		result = player->PlayerId;
	else
		result = -1;
	return result;
}

static bool isClientId(const int id)
{
	return id > 0 && id < 128 && Find_Player(id);
}

void NewPPAGE(int PlayerID, const char* Message)
{
	float Version = Get_Client_Version(PlayerID);
	wchar_t *PlayerName = Find_Player(PlayerID)->PlayerName.Peek_Buffer();
	
	if (Version >= 2.9) // Run our custom fake PPAGE if the player's scripts version supports it
	{
		StringClass SendText = StringClass::getFormattedString("%s %s", PrependText, Message);

		Send_Message_Player(Get_GameObj(PlayerID), RedColour, GreenColour, BlueColour, SendText);
		Create_2D_WAV_Sound_Player(Get_GameObj((PlayerID)), SoundFile);
	}
	else if (Is_WOL_User(PlayerName)) // Else if he's on WOL use PAGE
	{
		Console("PAGE %S %s", PlayerName, Message);
	}
	else // Else fall back to default PPAGE code
	{
		Send_Client_Text(Message, TEXT_MESSAGE_PRIVATE, false, -1, PlayerID, true, true);
	}
}

class CommandPPAGE :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "ppage"; 
	}
	const char* Get_Help() 
	{ 
		return "PPAGE <player> <message> - Sends a page to a specific player. Host only.";
	}
	void Activate(const char* argumentsString)
	{
		StringClass OriginalString = argumentsString;
		CommandLineParser arguments(argumentsString);

		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please enter a player ID.");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid player ID.");
			}
			else
			{
				const char* message = arguments.getRemainingString();
				if(!message)
				{
					Console_Output("Please enter a message to send.");
				}
				else
				{
					NewPPAGE(clientId, message);
				}
			}
		}
	}
};


class BetterPPAGEConsoleCommand : public Plugin
{
public:
	BetterPPAGEConsoleCommand()
	{
		RegisterEvent(EVENT_GLOBAL_INI,this);

		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{
				if (strcmp(name, "ppage") == 0)
				{
					ConsoleFunctionList.DeleteObj((*consoleFunction));
				}
			}
		}
		ConsoleFunctionList.Add(new CommandPPAGE);
		Sort_Function_List();
		Verbose_Help_File();

	}

	virtual void OnLoadGlobalINISettings(INIClass *SSGMIni)
	{
		SSGMIni->Get_String(PrependText, "BetterPPAGEConsoleCommand", "PrependText", "");
		SSGMIni->Get_String(SoundFile, "BetterPPAGEConsoleCommand", "SoundFile", "");
		RedColour = (unsigned int)SSGMIni->Get_Int("BetterPPAGEConsoleCommand", "RedColour", 255);
		GreenColour = (unsigned int)SSGMIni->Get_Int("BetterPPAGEConsoleCommand", "GreenColour", 250);
		BlueColour = (unsigned int)SSGMIni->Get_Int("BetterPPAGEConsoleCommand", "BlueColour", 250);
	}

	~BetterPPAGEConsoleCommand()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "ppage") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

BetterPPAGEConsoleCommand betterPPAGEConsoleCommand;


extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &betterPPAGEConsoleCommand;
}